<?php

require __DIR__ . "/../db/database.php";

// Pārbauda, vai ir kaut kas ievadīts meklēšanas laukā un vai tas nav tukšs
if (isset($_GET["search"]) && !empty($_GET["search"])) {
    //Ja ir, iegūst meklēto vērtību
    $search = $_GET["search"];

    // Sagatavo datubāzes pieprasījumu pēc autora vai nosaukuma
    $stmt = $mysqli->prepare("SELECT * FROM books WHERE author LIKE ? OR title LIKE ?");
    if (!$stmt) {
        die("Error preparing statement: " . $mysqli->error);
    }

    // Sagatavo meklēšanas parametrus, lai atbilstu datubāzes formātam
    $searchParam = "%$search%";
    $stmt->bind_param("ss", $searchParam, $searchParam);
    $stmt->execute();

    $result = $stmt->get_result();

    // Ja ir atrasta grāmata pēc nosaukuma vai autora
    if ($result->num_rows > 0) {
        // Parādām katru atrasto grāmatu kā kārtiņu
        while ($row = $result->fetch_assoc()) {
            //Izveido grāmatas kartiņas kamēr nav visas grāmatas izveidotas
            echo '<div class="card" data-bookId="'. $row['id'] .'">';
            echo '<div class="image">';
            echo '<img src="../uploads/' . $row["image"] . '" alt="">';
            echo '</div>';
            echo '<div class="info">';
            echo '<h2 class="heading" title="' . $row["title"] . '">' . (mb_strlen($row["title"]) > 15 ? mb_substr($row["title"], 0, 8) . '...' : $row["title"]) . '</h2>';
            echo '<p class="description">' . $row["description"] . '</p>';
            echo '</div>';
            echo '</div>';
        }
    } else {
        // Ja nav atrasta neviena grāmata ar norādīto meklēšanas nosacījumu
        echo "Nav atrasta grāmata.";
    }

    $stmt->close();
}



